<?php
/**
* Partial that generates the markup for a <textarea> element with its corresponding label. 
*
* Form markup generator partials are designed to follow object-oriented-esque patterns of inheritance.  This partial will by default be used by the 
* {@link Text_area_markup_generator} and all of its children that do not have a partial named after their {@link Field_markup_generator::$_type type}.
* If you wish to override this partial in your application, please follow the instructions in the "Partials and Markup Generation" section of the
* {@link Field_markup_generator} class documentation.
*
* Like all {@link Field_markup_generator} partials, this partial expects to be passed a copy of the markup generator calling it, called $markup_generator.
*
* @package icarus
* @subpackage form-markup-generator
*
* @author M. Gibbs <gibbs_margaret@bah.com> Last updated 2012-08-02
*/

if(!isset($markup_generator) || !is_a($markup_generator, 'Field_markup_generator'))
	$this->error->should_be_a_field_markup_generator($markup_generator);
	
?>
<div class="field-markup-container <?php echo implode(' ', $markup_generator->classes('-markup-container')) ?>" id="<?php echo $markup_generator->id_for_container ?>">
	<span class="label-container <?php echo implode(' ', $markup_generator->classes('-label-container')) ?>"><?php echo $label_markup ?></span>
	<span class="field-container <?php echo implode(' ', $markup_generator->classes('-field-container')) ?>">
    <?php if(!$markup_generator->inline && !$markup_generator->property_is_empty('comment')): ?>
    	<div class="form-field-comment"><?php echo $markup_generator->comment ?></div>
		<?php endif ?>
		<?php echo $field_markup ?>
    <?php if($markup_generator->inline && !$markup_generator->property_is_empty('comment')): ?>
    	<div class="form-field-comment"><?php echo $markup_generator->comment ?></div>
		<?php endif ?>
  </span>
</div>
